import 'package:flutter/material.dart';
import 'package:flutter_localizations/flutter_localizations.dart';

import '../../constants/app_constants.dart';
import '../../route/app_router.dart';
import '../../utility/custom_scrool.dart';
import '../../utility/custom_unfocus.dart';
import '../bloc_provider/multi_bloc_providers.dart';
import '../theme/app_theme.dart';
import 'main_builder.dart';

final GlobalKey<NavigatorState> navigatorKey = GlobalKey<NavigatorState>();

class MyApp extends StatelessWidget {
  const MyApp({super.key});
  @override
  Widget build(BuildContext context) {
    return AppBlocProviders(
      child: CustomUnfocus(
        child: MaterialApp(
          navigatorKey: navigatorKey,
          debugShowCheckedModeBanner: false,
          localizationsDelegates: const [
            GlobalMaterialLocalizations.delegate,
            GlobalCupertinoLocalizations.delegate,
            GlobalWidgetsLocalizations.delegate,
          ],
          scrollBehavior: CustomScroll(),
          supportedLocales: const [Locale("tr", "TR")],
          builder: MainBuilder.build,
          locale: const Locale('tr'),
          title: ApplicationConstants.instance.appTitle,
          initialRoute: "/",
          onGenerateRoute: AppRouter.onGenerateRoute,
          theme: AppTheme(context).customAppTheme,
        ),
      ),
    );
  }
}
