import 'dart:developer' as devtools show log;

extension Log on dynamic {
    void log() {
    if (this is String) {
      devtools.log(this);
    } else if (this is int) {
      devtools.log(toString());
    } else if (this is double) {
      devtools.log(toString());
    } else if (this is List) {
      devtools.log(toString());
    } else if (this is Map) {
      devtools.log(toString());
    } else if (this is bool) {
      devtools.log(toString());
    } else {
      devtools.log('Unknown Type: $this');
    }
  }
}

// Örnek Kullanım

//1 String içine değişken atayarak loglama
// 'bloc: $bloc'.log();

//2 bool isFinish = false;
// isFinish.log();