extension IntDivision on int {
  // Bu metod, bir int olarak verilen ikinci sayıyı parametre olarak alır.
  // İki sayıyı double'a çevirir ve bölme işlemini yapar.
  // Sonuç 1.0'dan büyükse, 1.0 olarak sınırlar. 0.0'dan küçükse, bu durumda 0.0 olamaz çünkü her iki sayı da pozitif kabul edilir.
  // Bu nedenle, sonuç negatifse bu bir hata olur ve kontrol edilmelidir.
  double approximateDivide(int other, {double defaultValue = 0.0}) {
    if (other == 0) {
      // Bölenin 0 olması durumunda kontrol
      return defaultValue;
    }

    double num1 = toDouble();
    double num2 = other.toDouble();
    double result = num1 / num2;

    if (result > 1.0) {
      return 1.0; // Sonucu 1.0 ile sınırla
    } else {
      return result; // Sonuç zaten 0.0 ile 1.0 arasında
    }
  }
}

  /// -  Example
  // Extension'ı kullanarak işlem yapalım.
  // int num1 = 5;
  // int num2 = 10;

  // num1 ve num2 için bölme işlemi yapılır.
  // double result = num1.safeDivide(num2);
  // print(result); // Eğer num1 <= num2, varsayılan değer olan 0.0'ı döndürür.

  // Başka bir örnek
  // double result2 = num2.safeDivide(
  //     num1); // Bu sefer num2 > num1 olduğu için bölme işlemi yapılır.
  // print(result2); // Bölme sonucunu döndürür.


