import 'package:flutter/material.dart';

extension ColorExtension on Color {
  Color toColorPicker(String color) {
    if (color.isNotEmpty && color.contains('rgb(')) {
      String cleanString = color.replaceAll('rgb(', '').replaceAll(')', '');
      List<String> values = cleanString.split(",");
      int red = int.parse(values[0].trim());
      int green = int.parse(values[1].trim());
      int blue = int.parse(values[2].trim());
      return Color.fromRGBO(red, green, blue, 1.0);
    }
    return const Color.fromARGB(255, 240, 164, 101);
  }
}
