part of 'notification_cubit.dart';

final class NotificationState extends Equatable {
  final List<NotificationModel> viewedNotification;
  final List<NotificationModel> unViewedNotification;
  final int badgeCount;
  final bool isLoading;
  final bool isError;
  final bool isComplete;

  const NotificationState(
      {required this.viewedNotification,
      required this.unViewedNotification,
      required this.badgeCount,
      required this.isLoading,
      required this.isComplete,
      required this.isError});

  factory NotificationState.initial() {
    return const NotificationState(
      viewedNotification: <NotificationModel>[],
      unViewedNotification: <NotificationModel>[],
      badgeCount: 0,
      isLoading: false,
      isError: false,
      isComplete: false,
    );
  }

  NotificationState copyWith({
    List<NotificationModel>? viewedNotification,
    List<NotificationModel>? unViewedNotification,
    int? badgeCount,
    bool? isLoading,
    bool? isError,
    bool? isComplete,
  }) {
    return NotificationState(
      viewedNotification: viewedNotification ?? this.viewedNotification,
      unViewedNotification: unViewedNotification ?? this.unViewedNotification,
      badgeCount: badgeCount ?? this.badgeCount,
      isLoading: isLoading ?? this.isLoading,
      isError: isError ?? this.isError,
      isComplete: isComplete ?? this.isComplete,
    );
  }

  @override
  List<Object?> get props =>
      [viewedNotification,unViewedNotification, badgeCount, isLoading, isError, isComplete];
}
