import 'dart:async';

class ErrorHandlingBloc {
  final _errorController = StreamController<String>();

  Stream<String> get errorStream => _errorController.stream;

  void handleError(String message) {
    _errorController.sink.add(message);
  }

  void dispose() {
    _errorController.close();
  }
}

final errorHandlingBloc = ErrorHandlingBloc();