part of 'dropdown_cubit.dart';

// Cubit durumunu temsil eden sınıf
// ignore: must_be_immutable
class DropdownState extends Equatable {
  final List<YetkiliDDModel> yetkililer;
  final List<CalisanYetkiliDDModel> calisanlar;
  final List<ProjeDDModel> projeler;
  List<YetkiliDDModel> secilenYetkililer;
  List<CalisanYetkiliDDModel> secilenCalisanlar;
  final bool isLoading;
  final bool isError;
  final bool isComplete;

  DropdownState({
    required this.yetkililer,
    required this.calisanlar,
    required this.projeler,
    required this.secilenYetkililer,
    required this.secilenCalisanlar,
    required this.isLoading,
    required this.isError,
    required this.isComplete,
  });

  factory DropdownState.initial() {
    return DropdownState(
      yetkililer: const [],
      calisanlar: const [],
      projeler: const [],
      secilenYetkililer: const [],
      secilenCalisanlar: const [],
      isLoading: false,
      isError: false,
      isComplete: false,
    );
  }

  DropdownState copyWith({
    List<YetkiliDDModel>? yetkililer,
    List<CalisanYetkiliDDModel>? calisanlar,
    List<ProjeDDModel>? projeler,
    List<YetkiliDDModel>? secilenYetkililer,
    List<CalisanYetkiliDDModel>? secilenCalisanlar,
    bool? isLoading,
    bool? isCorrect,
    bool? isError,
    bool? isComplete,
  }) {
    return DropdownState(
      yetkililer: yetkililer ?? this.yetkililer,
      calisanlar: calisanlar ?? this.calisanlar,
      projeler: projeler ?? this.projeler,
      secilenYetkililer: secilenYetkililer ?? this.secilenYetkililer,
      secilenCalisanlar: secilenCalisanlar ?? this.secilenCalisanlar,
      isLoading: isLoading ?? this.isLoading,
      isError: isError ?? this.isError,
      isComplete: isComplete ?? this.isComplete,
    );
  }

  @override
  List<Object?> get props => [
        yetkililer,
        calisanlar,
        projeler,
        secilenYetkililer,
        secilenCalisanlar,
        isLoading,
        isError,
        isComplete
      ];
}
