import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

import 'color_constants.dart';

final class FontStyles {
  static FontStyles? _instance;
  static FontStyles get instance {
    _instance ??= FontStyles._init();
    return _instance!;
  }

  FontStyles._init();

  final TextStyle versionTxt =
      GoogleFonts.akshar(color: Colors.black54, fontSize: 14);
  final TextStyle appbarTitleStyle = GoogleFonts.inter(
      color: Colors.black, fontWeight: FontWeight.w400, fontSize: 16);
  final TextStyle alertMessageTitleStyle =
      GoogleFonts.robotoFlex(fontSize: 20, color: const Color(0xFF004789));
  final TextStyle alertMessageButtonTextStyle =
      GoogleFonts.roboto(fontSize: 15, color: Colors.white);
  final TextStyle ortaYazi = GoogleFonts.inter(fontSize: 12);
  final TextStyle buyukYazi = GoogleFonts.inter(fontSize: 14);
  final TextStyle robotoYazi = GoogleFonts.roboto(fontSize: 20);
  final TextStyle tabBarYazi =
      GoogleFonts.roboto(fontSize: 13, color: Colors.grey.shade500);
  final TextStyle splashYazi =
      GoogleFonts.robotoFlex(fontSize: 27, color: const Color(0xFF004789));
  final TextStyle girisBtnYazi =
      GoogleFonts.robotoFlex(fontSize: 20, color: const Color(0xFFFFFFFF));
  final TextStyle ddYazi =
      GoogleFonts.inter(fontSize: 12, color: const Color(0xFF141312));
  final TextStyle employeetbxBaslik = GoogleFonts.inter(
      fontSize: 13, color: ColorsConstants.instance.baseTheme);
  final TextStyle employeetbxYazi =
      GoogleFonts.inter(fontSize: 12, color: Colors.grey.shade700);
  final TextStyle employeebxDdyazi =
      GoogleFonts.inter(fontSize: 15, color: Colors.grey.shade700);
  final TextStyle employeetbxError =
      GoogleFonts.inter(fontSize: 12, color: Colors.amber.shade900);
  final TextStyle employeetbxRequired =
      GoogleFonts.inter(fontSize: 10, color: Colors.red.shade900);
  final TextStyle ddBaslik =
      GoogleFonts.inter(fontSize: 13, color: const Color(0xFF141312));
  final TextStyle activityYazi =
      GoogleFonts.inter(fontSize: 13, color: const Color(0xFF141312));
  final TextStyle bekleyenIzinYazi = GoogleFonts.inter(
      fontSize: 11, color: ColorsConstants.instance.baseTheme);
  final TextStyle bekleyenIzinYaziKalin = GoogleFonts.inter(
      fontSize: 11,
      color: ColorsConstants.instance.baseTheme,
      fontWeight: FontWeight.bold);
  final TextStyle cevaplananIzinYazi =
      GoogleFonts.inter(fontSize: 11, color: Colors.grey.withOpacity(0.85));
  final TextStyle cevaplananIzinYaziKalin = GoogleFonts.inter(
      fontSize: 11,
      color: Colors.grey.withOpacity(0.85),
      fontWeight: FontWeight.bold);
  final TextStyle projectbxBaslik = GoogleFonts.inter(
      fontSize: 13, color: ColorsConstants.instance.baseTheme);
  final TextStyle projectbxDdyazi =
      GoogleFonts.inter(fontSize: 11, color: Colors.grey.shade700);
  final TextStyle meetGeneralStyle =
      GoogleFonts.roboto(fontSize: 14, color: Colors.grey.shade700);
}
