// Lazy Singleton (Tembel Singleton): İlk kez kullanıldığında örneği oluşturan bir tür singleton çeşididir. Yani, sadece ihtiyaç duyulduğunda örnek oluşturulur.
// Bu, uygulama başlangıcında gereksiz yere örnek oluşturulmasını önler ve kaynakları daha etkin bir şekilde kullanmanıza yardımcı olur.
import 'package:flutter/material.dart';

final class ColorsConstants {
  static ColorsConstants? _instance;
  static ColorsConstants get instance {
    _instance ??= ColorsConstants._init();
    return _instance!;
  }

  ColorsConstants._init();
  final Color baseTheme = const Color(0xFF055928);
  final Color baseThemeV2 = const Color(0xFF09AB08).withOpacity(0.25);
  final Color messageTileBaloonTheme = const Color(0xFFFFFFFF);
  final Color messageOwnBaloonTheme = const Color(0xFFDCF7C5);
  final Color selectedDateCalendar = const Color(0xFFbcbcbc);
  final Color appGrey = const Color(0xFFc0c7c4);
  final Color backgroundColor = const Color(0xFFF8F8F8);
  final Color shadowColor = const Color(0xFFD4EBFF);
  final Color appWhite = const Color(0xFFFFFFFF);
  final Color appRed = const Color(0xFFEE1111);
  final Color appGreen = const Color(0xFF09AB08);
  final Color appWaterGreen = const Color(0xFF75a832);
  final Color appBlue = const Color(0xFF005b96);
  final Color iconColor = const Color(0xFFD6D6D6);
  final Color selectedDateTextColor = Colors.black54;
  final Color containerBorderGreyColor = const Color(0xFF9E9E9E);
  final Color navigationMeetButtonGreyColor = const Color(0xFF282625);

  final customColors = [
    Colors.orange,
    Colors.red,
    Colors.green,
    Colors.blue,
    Colors.yellow,
    Colors.pink,
    Colors.greenAccent,
    Colors.blueGrey,
    Colors.purpleAccent,
    Colors.orangeAccent,
    Colors.blueAccent,
  ];
}

// ColorConstants sınıfı yapısın da doğru bir singleton deseni uygulanmıştır. 
// ColorConstants sınıfının örneği yalnızca _init() constructor'ı içinde oluşturulur ve daha sonrasında getter aracılığıyla erişilir.
