final class ApplicationConstants {
  static ApplicationConstants? _instance;
  static ApplicationConstants get instance {
    _instance ??= ApplicationConstants._init();
    return _instance!;
  }

  ApplicationConstants._init();

  // APP TITLE

  final String appTitle = 'Hamle Mühendislik CRM';

  // CERTIFICATE PATH

  final String certificatePath = 'assets/ca/lets-encrypt-r3.pem';

  // HOME TEXT

  final favoritesListTxt = 'Sık Kullanılanlar';

  // MODULE NAMES TEXT

  final String homePageTxt = 'Anasayfa';
  final String profilePageTxt = 'Profil';
  final String notificationPageTxt = 'Bildirimler';
  final String projectModuleTxt = 'Projeler & Görevler';
  final String humanResourcesModuleTxt = 'Personel Yönetimi';
  final String customersModuleTxt = 'Müşteriler / Aktiviteler';
  final String customersModuleSubTxt = 'Müşteriler';
  final String calendarModuleTxt = 'Toplantılar';
  final String messageModuleTxt = 'Mesajlar';
  final String newsModuleTxt = 'Haberler';

  // BUTTON TEXT
  final String moduleSaveTxt = 'KAYDET';
  final String moduleDeleteTxt = 'SİL';
  final String moduleUpdateTxt = 'GÜNCELLE';
  final String moduleCancelTxt = "İPTAL";
  final String moduleArchiveTxt = 'ARŞİVLE';
  final String moduleUnArchiveTxt = 'ARŞİVDEN ÇIKART';
  final String moduleNextTxt = 'DEVAM ET';

  // SHORTCUT TEXT
  final String betaTagTxt = 'BETA';
  final String newTagTxt = 'NEW';
  final String allPermissionSendTxt = 'Tüm İzin Taleplerim';
  final String employeeInformationTxt = 'Çalışan Bilgileri';
  final String allMissionTxt = 'Tüm Görevler';
  final String signoutSessionTxt = 'Oturumdan Çık';
  final String closeAppTxt = 'Uygulamayı Kapat';

  // REGEX VALIDATION
  final String mailRegEx = r'^[^@]+@[^@]+\.[^@]+';

  // CALL TYPE LIST
  final Map<String, String> callType = {
    'telefon': 'Telefon Görüşmesi',
    'mailgorusmesi': 'Mail Görüşmesi',
    'online': 'Online Görüşme',
    'gelenmusteriyuzyuze': 'Gelen Müşteri Yüz Yüze',
    'musteriziyaretiyuzyuze': 'Müşteri Ziyareti Yüz Yüze',
  };
  // MEET REPEATING LIST
  final Map<String, String> meetRepeat = {
    'yok': 'Tekrar Yok',
    'hergundebir': 'Her Günde Bir',
    'herhaftadabir': 'Her Haftada Bir ',
    'heraydabir': 'Her Ayda Bir',
  };

  // container borderRadius value

  double get kBorderRadius => 10.0;

  // child container to parent margin value

  double get kChildContainerMargin => 14.0;

  // edgeStartContainerWidth

  double get kEdgeStartContainerWidthLow => 5.5;
  double get kEdgeStartContainerWidthMid => 6.5;
  double get kEdgeStartContainerWidthHigh => 7.5;
  double get kEdgeStartContainerWidthMax => 9.5;
}
